/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.futurepack.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class CentrifugeRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final int support;
    public final int time;

    public CentrifugeRecipeSerializer(ResourceLocation key, Object input, int inputCount, int support, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.support = support;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        if (this.input == Items.f_41852_ || this.inputCount <= 0) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe: {}", (Object)this.key);
                continue;
            }
            results.add(stack);
        }
        if (results.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "futurepack:zentrifuge");
        JsonObject inputJson = new JsonObject();
        if (this.input instanceof String || this.input instanceof ResourceLocation) {
            inputJson.addProperty("tag", this.input.toString());
        } else if (this.input instanceof ItemLike) {
            inputJson.addProperty("name", ((ItemLike)this.input).m_5456_().getRegistryName().toString());
        }
        inputJson.addProperty("size", (Number)this.inputCount);
        json.add("input", (JsonElement)inputJson);
        JsonArray outputJson = new JsonArray();
        for (ItemStack stack : results) {
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("name", stack.m_41720_().getRegistryName().toString());
            resultJson.addProperty("size", (Number)stack.m_41613_());
            outputJson.add((JsonElement)resultJson);
        }
        json.add("output", (JsonElement)outputJson);
        json.addProperty("support", (Number)this.support);
        json.addProperty("time", (Number)this.time);
        return json;
    }
}

